/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.JoinFacade;
import cds.aladin.TapTable;
import cds.aladin.TapTableColumn;
import java.awt.FlowLayout;
import java.awt.Image;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class JoinConstraint
extends JPanel {
    private static final long serialVersionUID = -9057608446810725723L;
    public JoinFacade facade;
    public String mainTableName;
    public String joinTableName;
    public String constraint;
    JButton removeButton;
    public Vector<TapTableColumn> columns;
    public String raColumnName;
    public String decColumnName;
    public String alias;

    public JoinConstraint() {
        Image image = Aladin.aladin.getImagette("delete_button.png");
        this.removeButton = image == null ? new JButton("X") : new JButton(new ImageIcon(image));
        this.removeButton.setToolTipText("Click to delete this constraint");
        this.removeButton.setActionCommand("REMOVEWHERECONSTRAINT");
    }

    public JoinConstraint(JoinFacade facade, String mainTableName, TapTable secTableMetaData) {
        this();
        this.facade = facade;
        this.mainTableName = mainTableName;
        this.joinTableName = secTableMetaData.getTable_name();
        this.removeButton.addActionListener(this.facade);
        this.setAlais(facade.constraints);
        this.columns = this.getColumnsWithAlais(secTableMetaData, this.alias);
    }

    public Vector<TapTableColumn> getColumnsWithAlais(TapTable refTable, String alias) {
        Vector<TapTableColumn> results = new Vector<TapTableColumn>();
        TapTableColumn copy = null;
        TapTableColumn refRaCol = refTable.getFlaggedColumn("ra");
        TapTableColumn refDecCol = refTable.getFlaggedColumn("dec");
        for (TapTableColumn refColumn : refTable.getColumns()) {
            copy = new TapTableColumn(refColumn, alias);
            if (refRaCol != null && refRaCol == refColumn) {
                this.raColumnName = copy.getColumnNameForQuery();
            } else if (refDecCol != null && refDecCol == refColumn) {
                this.decColumnName = copy.getColumnNameForQuery();
            }
            results.add(copy);
        }
        return results;
    }

    public void setGui() {
        this.setLayout(new FlowLayout(0));
        this.add(this.removeButton);
        String label = null;
        String tooltip = null;
        if (this.constraint != null) {
            label = this.alias + " (" + this.constraint + " )";
            tooltip = "Join table: " + this.joinTableName + ", alais: " + this.alias + " (" + this.constraint + " )";
        } else {
            label = JoinFacade.GENERCIERROR_JOIN;
        }
        JLabel joinLabel = new JLabel(label);
        joinLabel.setToolTipText(tooltip);
        this.add(joinLabel);
    }

    public void setConstraintAndGui(String constraint) {
        this.constraint = constraint;
        this.setGui();
    }

    public void setAlais(List<JoinConstraint> otherConstraints) {
        this.alias = JoinConstraint.getAlais(this.mainTableName, this.joinTableName, otherConstraints);
    }

    public static String getAlais(String mainTableName, String joinTableName, List<JoinConstraint> otherConstraints) {
        int aliasIndex = 0;
        String alias = joinTableName;
        if (joinTableName.startsWith("TAP_UPLOAD.")) {
            alias = joinTableName.replace("TAP_UPLOAD.", "");
        }
        if (TapTable.isUnQuotedPattern(TapTable.getQueryPart(joinTableName, true))) {
            alias = alias.replaceAll("\\.", "");
        }
        String aliasNameInWorks = alias;
        if (mainTableName.equalsIgnoreCase(joinTableName)) {
            aliasNameInWorks = alias + ++aliasIndex;
        }
        ArrayList<String> tableNames = new ArrayList<String>();
        tableNames.add(mainTableName);
        for (JoinConstraint otherConstraint : otherConstraints) {
            tableNames.add(otherConstraint.alias);
        }
        aliasNameInWorks = TapTable.getQueryPart(aliasNameInWorks, false);
        alias = JoinConstraint.getUniqueTableName(aliasIndex, alias, aliasNameInWorks, tableNames);
        return alias;
    }

    private static String getUniqueTableName(int index, String init, String input, List<String> takenValues) {
        String resultInWorks = input;
        if (!takenValues.contains(input)) {
            return input;
        }
        resultInWorks = init + ++index;
        resultInWorks = TapTable.getQueryPart(resultInWorks, false);
        return JoinConstraint.getUniqueTableName(index, init, resultInWorks, takenValues);
    }

    public String getADQLString() {
        String result = "";
        if (this.constraint != null && !this.constraint.isEmpty()) {
            StringBuffer whereClause = new StringBuffer(" JOIN ");
            whereClause.append(TapTable.getQueryPart(this.joinTableName, true));
            if (this.alias != null) {
                whereClause.append(" AS ").append(this.alias);
            }
            whereClause.append(" ON ").append(this.constraint);
            result = whereClause.toString();
        }
        return result;
    }

    public boolean hasThisColumn(TapTableColumn tapTableColumn) {
        boolean result = false;
        String fullyQualifiedTableName = this.joinTableName + "." + this.alias;
        if (fullyQualifiedTableName.equalsIgnoreCase(tapTableColumn.getTable_name())) {
            result = true;
        }
        return result;
    }
}

